(()=>{"use strict";const e="1.2.0";console.log(`[Background v${e}] Script loaded at ${(new Date).toISOString()}`);const t=!chrome.runtime.id.includes("development");let a="https://talented.co/api";const s="queue-keep-alive";chrome.storage.local.get(["baseUrl"]).then(e=>{e.baseUrl?(a=e.baseUrl,console.log("[Background] Loaded base URL from storage:",a)):console.log("[Background] Using default base URL:",a)});class o{static async getToken(){const e=(await chrome.storage.local.get(this.TOKEN_KEY))[this.TOKEN_KEY];return e?Date.now()>=e.expiresAt?(await this.clearToken(),null):e.token:null}static async setToken(e,t){const a={token:e,expiresAt:Date.now()+1e3*t};await chrome.storage.local.set({[this.TOKEN_KEY]:a})}static async clearToken(){await chrome.storage.local.remove(this.TOKEN_KEY)}}async function n(e,t={}){console.log("[API] Making authenticated request to:",e);const s=await o.getToken();if(console.log("[API] Token retrieved:",s?"present":"missing"),!s)throw new Error("Not authenticated");const n=`${a}${e}`;console.log("[API] Full URL:",n);const r=await fetch(n,{...t,headers:{...t.headers,Authorization:`Bearer ${s}`,"Content-Type":"application/json","X-Extension-Version":chrome.runtime.getManifest().version}});if(console.log("[API] Response status:",r.status),401===r.status)throw await o.clearToken(),new Error("Authentication expired");return r}o.TOKEN_KEY="authToken";class r{static async initialize(){if(this.initialized)console.log(`[QueueManager v${e}] Already initialized`);else try{console.log(`[QueueManager v${e}] Initializing queue manager...`),await this.resetStuckItems(),this.startProcessor(),await this.broadcastQueueStatus(),await this.updateKeepAlive(),this.initialized=!0,console.log(`[QueueManager v${e}] Initialization complete`)}catch(t){console.error(`[QueueManager v${e}] Failed to initialize:`,t),setTimeout(()=>this.initialize(),1e3)}}static async resetStuckItems(){const t=await this.getQueue();let a=!1;for(const s of t)"processing"===s.status&&(console.log(`[QueueManager v${e}] Resetting stuck item from 'processing' to 'queued':`,s.id),s.status="queued",s.retryCount=(s.retryCount||0)+1,a=!0,s.retryCount>=3&&(console.log(`[QueueManager v${e}] Item exceeded retry limit, marking as failed:`,s.id),s.status="failed",s.error="Processing interrupted - exceeded retry limit",s.completedAt=Date.now()));a&&(await this.saveQueue(t),console.log(`[QueueManager v${e}] Reset stuck items in queue`))}static async ensureInitialized(){this.initialized||await this.initialize()}static async addToQueue(t){console.log(`[QueueManager v${e}] Starting addToQueue...`);try{console.log(`[QueueManager v${e}] Ensuring initialized...`),await this.ensureInitialized(),console.log(`[QueueManager v${e}] Getting current queue...`);let a=await this.getQueue();if(console.log(`[QueueManager v${e}] Current queue length:`,a.length),a.length>50){const t=a.filter(e=>"completed"===e.status).sort((e,t)=>(e.completedAt||0)-(t.completedAt||0)),s=Math.min(t.length,a.length-40);if(s>0){const o=t.slice(0,s).map(e=>e.id);a=a.filter(e=>!o.includes(e.id)),console.log(`[QueueManager v${e}] Auto-cleaned ${s} old completed items`)}}const s=`queue_${Date.now()}_${Math.random().toString(36).substr(2,9)}`;console.log(`[QueueManager v${e}] Generated item ID:`,s);const o={id:s,candidateData:t.candidateData,jobId:t.jobId,companyId:t.companyId,status:"queued",addedAt:Date.now(),retryCount:0};return a.push(o),console.log(`[QueueManager v${e}] Saving queue with new item...`),await this.saveQueue(a),console.log(`[QueueManager v${e}] Broadcasting queue status...`),await this.broadcastQueueStatus(),console.log(`[QueueManager v${e}] Successfully added item to queue:`,s),s}catch(t){throw console.error(`[QueueManager v${e}] Error adding to queue:`,t),t}}static async removeFromQueue(e){const t=(await this.getQueue()).filter(t=>t.id!==e);await this.saveQueue(t),await this.broadcastQueueStatus(),console.log("[QueueManager] Removed item from queue:",e)}static async skipQueueItem(t,a){const s=await this.getQueue(),o=s.findIndex(e=>e.id===t);-1!==o?(s[o].skipRequested=!0,s[o].status="completed",s[o].completedAt=Date.now(),s[o].error=void 0,s[o].result={skipped:!0,message:a||"Skipped manually"},s[o].candidateData={name:s[o].candidateData.name,email:s[o].candidateData.email,sourceId:s[o].candidateData.sourceId,source:s[o].candidateData.source},await this.saveQueue(s),await this.broadcastQueueStatus(),console.log(`[QueueManager v${e}] Skipped queue item:`,t)):console.log(`[QueueManager v${e}] Cannot skip missing item:`,t)}static async clearQueue(e){if("all"===e)await this.saveQueue([]);else{const t=(await this.getQueue()).filter(t=>"completed"===e?"completed"!==t.status:"failed"!==e||"failed"!==t.status);await this.saveQueue(t)}await this.broadcastQueueStatus(),console.log("[QueueManager] Cleared queue with filter:",e)}static async getQueue(){return(await chrome.storage.local.get(this.QUEUE_KEY))[this.QUEUE_KEY]||[]}static async saveQueue(e){await chrome.storage.local.set({[this.QUEUE_KEY]:e}),await this.updateKeepAlive(e)}static async getQueueStatus(){const e=await this.getQueue(),t={queued:e.filter(e=>"queued"===e.status).length,processing:e.filter(e=>"processing"===e.status).length,completed:e.filter(e=>"completed"===e.status).length,failed:e.filter(e=>"failed"===e.status).length,total:e.length};return{items:e,processing:this.processing,stats:t}}static async broadcastQueueStatus(){const e=await this.getQueueStatus();chrome.runtime.sendMessage({type:"QUEUE_UPDATE",queue:e}).catch(()=>{}),chrome.storage.local.set({queueStatus:e,queueUpdatedAt:Date.now()})}static async updateKeepAlive(t){try{if(!chrome.alarms||!chrome.alarms.create||!chrome.alarms.clear)return;(t||await this.getQueue()).some(e=>"queued"===e.status||"processing"===e.status)?chrome.alarms.create(s,{periodInMinutes:1}):chrome.alarms.clear(s)}catch(t){console.warn(`[QueueManager v${e}] Failed to update keep-alive alarm:`,t)}}static startProcessor(){this.processingInterval||(console.log("[QueueManager] Starting queue processor..."),this.processingInterval=setInterval(async()=>{if(this.processing)return;const e=(await this.getQueue()).find(e=>"queued"===e.status);e&&await this.processQueueItem(e)},2e3))}static async processQueueItem(t){this.processing=!0,console.log(`[QueueManager v${e}] Processing queue item:`,t.id);let a=await this.getQueue();const s=a.findIndex(e=>e.id===t.id);if(-1===s)return console.log(`[QueueManager v${e}] Item not found in queue:`,t.id),void(this.processing=!1);if(a[s].skipRequested)return a[s].status="completed",a[s].completedAt=Date.now(),a[s].error=void 0,a[s].result={...a[s].result||{},skipped:!0,message:"Skipped manually"},await this.saveQueue(a),await this.broadcastQueueStatus(),void(this.processing=!1);try{if(a[s].status="processing",a[s].startedAt=Date.now(),await this.saveQueue(a),await this.broadcastQueueStatus(),t.candidateData.sourceId){console.log(`[QueueManager v${e}] Checking if candidate exists:`,t.candidateData.sourceId);try{const s=await u({platform:t.candidateData.source||"indeed",platformId:t.candidateData.sourceId,companyId:t.companyId});if(s.found){console.log(`[QueueManager v${e}] Candidate already exists in DB:`,s.candidate.id),a=await this.getQueue();const o=a.findIndex(e=>e.id===t.id);return void(-1!==o&&(a[o].status="completed",a[o].completedAt=Date.now(),a[o].result={candidateId:s.candidate.id,analysis:s.latestApplication?.aiScreeningResult?{matchScore:s.latestApplication.aiScreeningResult.matchScore,recommendation:s.latestApplication.aiScreeningResult.recommendation}:void 0,message:"Candidate already exists in database",skipped:!0},a[o].candidateData={name:t.candidateData.name,email:t.candidateData.email,sourceId:t.candidateData.sourceId,source:t.candidateData.source},await this.saveQueue(a),console.log(`[QueueManager v${e}] Marked as completed (already exists):`,t.id)))}}catch(t){console.warn(`[QueueManager v${e}] Error checking candidate existence:`,t)}}const o=await c({profileData:t.candidateData,jobId:t.jobId,companyId:t.companyId,invite:!1});a=await this.getQueue();const n=a.findIndex(e=>e.id===t.id);if(-1!==n){if(a[n].skipRequested)return void(this.processing=!1);a[n].status="completed",a[n].completedAt=Date.now(),a[n].result={candidateId:o.candidateId,applicationId:o.applicationId,status:o.status,message:o.message,skipped:o.skipped,analysis:o.analysis?{matchScore:o.analysis.matchScore,recommendation:o.analysis.recommendation}:void 0},a[n].candidateData={name:t.candidateData.name,email:t.candidateData.email,sourceId:t.candidateData.sourceId,source:t.candidateData.source},await this.saveQueue(a),console.log(`[QueueManager v${e}] Successfully processed item:`,t.id,"Status:",a[n].status)}}catch(s){console.error(`[QueueManager v${e}] Failed to process item:`,t.id,s),a=await this.getQueue();const o=a.findIndex(e=>e.id===t.id);if(-1!==o){if(a[o].skipRequested)return void(this.processing=!1);a[o].status="failed",a[o].completedAt=Date.now(),a[o].error=s.message||"Unknown error",a[o].retryCount=(a[o].retryCount||0)+1,a[o].retryCount<3?(console.log(`[QueueManager v${e}] Retrying item:`,t.id,"Attempt:",a[o].retryCount),a[o].status="queued"):a[o].candidateData={name:t.candidateData.name,email:t.candidateData.email,sourceId:t.candidateData.sourceId,source:t.candidateData.source},await this.saveQueue(a)}}finally{await this.broadcastQueueStatus(),this.processing=!1;const a=(await this.getQueue()).find(e=>e.id===t.id);console.log(`[QueueManager v${e}] Final status for ${t.id}:`,a?.status)}}static stopProcessor(){this.processingInterval&&(clearInterval(this.processingInterval),this.processingInterval=null,console.log("[QueueManager] Stopped queue processor"))}}r.QUEUE_KEY="candidateQueue",r.processing=!1,r.processingInterval=null,r.initialized=!1;class i{static async getUserContext(){console.log("[ContextManager] Getting user context...");const e=(await chrome.storage.local.get(this.CONTEXT_KEY))[this.CONTEXT_KEY];return console.log("[ContextManager] Stored context:",e),e?Date.now()-e.lastUpdated>3e5?(console.log("[ContextManager] Context cache expired, refreshing..."),this.refreshUserContext()):(console.log("[ContextManager] Returning cached context"),e.user):(console.log("[ContextManager] No stored context, refreshing..."),this.refreshUserContext())}static async refreshUserContext(){try{console.log("[ContextManager] Refreshing user context...");const e=await n("/extension/user/context");if(console.log("[ContextManager] Response status:",e.status),!e.ok){const t=await e.text();return console.error("[ContextManager] Error response:",t),null}const t=await e.json();console.log("[ContextManager] User data received:",t);const a={user:t,lastUpdated:Date.now()};return await chrome.storage.local.set({[this.CONTEXT_KEY]:a}),console.log("[ContextManager] Context saved to storage"),t}catch(e){return console.error("[ContextManager] Failed to refresh user context:",e),null}}static async setSelectedCompany(e){const t=await this.getUserContext();t&&(t.selectedCompanyId=e,await chrome.storage.local.set({[this.CONTEXT_KEY]:{user:t,lastUpdated:Date.now()}}))}static async setSelectedJob(e){const t=await this.getUserContext();t&&(t.selectedJobId=e,await chrome.storage.local.set({[this.CONTEXT_KEY]:{user:t,lastUpdated:Date.now()}}))}static async getSettings(){return(await chrome.storage.local.get(this.SETTINGS_KEY))[this.SETTINGS_KEY]||{autoAnalyze:!1,showScoreBadges:!0,enableBulkMode:!0,learningMode:!1}}static async updateSettings(e){const t=await this.getSettings();await chrome.storage.local.set({[this.SETTINGS_KEY]:{...t,...e}})}}async function c(e){return(await n("/extension/candidates/import",{method:"POST",body:JSON.stringify(e)})).json()}async function u(e){return(await n("/extension/candidates/check-by-platform",{method:"POST",body:JSON.stringify(e)})).json()}function d(){if(console.log("Talented Sourcing Extension installed"),chrome.contextMenus&&chrome.contextMenus.create)try{chrome.contextMenus.removeAll(()=>{chrome.contextMenus.create({id:"talented-import",title:"Import to Talented",contexts:["selection"]},()=>{chrome.runtime.lastError&&console.error("Context menu error:",chrome.runtime.lastError.message)})})}catch(e){console.error("Failed to setup context menu:",e)}chrome.contextMenus&&chrome.contextMenus.onClicked&&chrome.contextMenus.onClicked.addListener((e,t)=>{"talented-import"===e.menuItemId&&t?.id&&chrome.tabs.sendMessage(t.id,{type:"IMPORT_SELECTION",text:e.selectionText})}),chrome.sidePanel&&chrome.sidePanel.setPanelBehavior&&chrome.sidePanel.setPanelBehavior({openPanelOnActionClick:!0}).catch(e=>console.error("Side panel setup error:",e))}i.CONTEXT_KEY="userContext",i.SETTINGS_KEY="extensionSettings",chrome.runtime.onMessage.addListener((s,d,l)=>(console.log(`[Background v${e}] Message received:`,s.type),chrome.runtime&&chrome.runtime.id,"AUTHENTICATE"===s.type?(async function(){const e=`${a}/extension/auth`,t=await chrome.windows.create({url:e,type:"popup",width:500,height:600});return new Promise((e,a)=>{let s=0;const n=async()=>{if(s++,!t.id)return clearInterval(r),void a(new Error("Auth window closed"));try{const n=await chrome.tabs.query({windowId:t.id});if(0===n.length)return clearInterval(r),void a(new Error("No tabs in auth window"));const i=n[0];if(!i.url)return;let c;try{c=new URL(i.url)}catch(e){return}if("/extension/auth/callback"===c.pathname||c.pathname.includes("/extension/auth/callback")){console.log("[Auth] Found callback URL!"),console.log("[Auth] Full URL:",c.toString()),console.log("[Auth] Pathname:",c.pathname),console.log("[Auth] Search params:",c.search),console.log("[Auth] All params:",Array.from(c.searchParams.entries()));const n=c.searchParams.get("token"),i=c.searchParams.get("code"),u=parseInt(c.searchParams.get("expiresIn")||"3600");console.log("[Auth] Extracted - token:",n?`present (${n.substring(0,10)}...)`:"missing","code:",i?`present (${i})`:"missing"),n?(console.log("[Auth] Token found!"),await o.setToken(n,u),setTimeout(()=>{console.log("[Auth] Closing auth window after success"),t.id&&chrome.windows.remove(t.id)},1500),clearInterval(r),e({success:!0})):i?s>=60&&(clearInterval(r),a(new Error("Authentication timeout"))):(console.log("[Auth] No code or token found, authentication failed"),clearInterval(r),a(new Error("Authentication failed")))}}catch(e){console.error("[Auth] Check error:",e),s>=60&&(clearInterval(r),a(new Error("Authentication failed")))}},r=setInterval(n,500);n()})}().then(l).catch(e=>{l({error:e.message})}),!0):"GET_USER_CONTEXT"===s.type?(i.getUserContext().then(l).catch(e=>{l({error:e.message})}),!0):"SET_SELECTED_COMPANY"===s.type?(i.setSelectedCompany(s.companyId).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"SET_SELECTED_JOB"===s.type?(i.setSelectedJob(s.jobId).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"ANALYZE_CANDIDATE"===s.type?(async function(e){return(await n("/extension/candidates/analyze",{method:"POST",body:JSON.stringify(e)})).json()}(s.data).then(l).catch(e=>{l({error:e.message})}),!0):"IMPORT_CANDIDATE"===s.type?(c(s.data).then(l).catch(e=>{l({error:e.message})}),!0):"BULK_IMPORT_CANDIDATES"===s.type?(async function(e){return(await n("/extension/candidates/bulk-import",{method:"POST",body:JSON.stringify(e)})).json()}(s.data).then(l).catch(e=>{l({error:e.message})}),!0):"GET_COMPANY_JOBS"===s.type?(async function(e){return(await n(`/extension/companies/${e}/jobs`)).json()}(s.companyId).then(l).catch(e=>{l({error:e.message})}),!0):"GET_ALL_JOBS"===s.type?(async function(){return(await n("/extension/jobs/all")).json()}().then(l).catch(e=>{l({error:e.message})}),!0):"SAVE_LEARNING_DATA"===s.type?(async function(e){await async function(e,t){return new Promise((a,s)=>{const o=indexedDB.open("TalentedExtension",1);o.onupgradeneeded=e=>{const t=e.target.result;t.objectStoreNames.contains("learning_data")||t.createObjectStore("learning_data",{keyPath:"id",autoIncrement:!0})},o.onsuccess=o=>{const n=o.target.result.transaction([e],"readwrite");n.objectStore(e).add({...t,id:Date.now()}),n.oncomplete=()=>a(),n.onerror=()=>s(n.error)},o.onerror=()=>s(o.error)})}("learning_data",e),t||await n("/extension/learning/save",{method:"POST",body:JSON.stringify(e)})}(s.data).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"UPDATE_SETTINGS"===s.type?(i.updateSettings(s.settings).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"CHECK_CANDIDATE"===s.type?(u(s.data).then(l).catch(e=>{l({error:e.message})}),!0):"CHECK_CANDIDATES_BULK"===s.type?(async function(e){return(await n("/extension/candidates/check-bulk",{method:"POST",body:JSON.stringify(e)})).json()}(s.data).then(l).catch(e=>{l({error:e.message})}),!0):"UPDATE_BASE_URL"===s.type?(a=s.baseUrl,console.log("[Background] Updated base URL to:",a),l({success:!0}),!1):"CONTENT_SCRIPT_LOADED"===s.type?(console.log("[Background] Content script loaded on:",s.url),console.log("[Background] Host:",s.host),l({success:!0,message:"Content script acknowledged"}),!1):"ADD_TO_QUEUE"===s.type?(console.log(`[Background v${e}] Processing ADD_TO_QUEUE request`),(async()=>{try{if(console.log(`[Background v${e}] ADD_TO_QUEUE data:`,s.data),!(s.data&&s.data.candidateData&&s.data.jobId&&s.data.companyId))throw new Error("Missing required data for queue item");await r.ensureInitialized();const t=await r.addToQueue(s.data);console.log(`[Background v${e}] Successfully added to queue:`,t),l({success:!0,itemId:t})}catch(t){console.error(`[Background v${e}] Error in ADD_TO_QUEUE:`,t),l({error:t.message||"Failed to add to queue",details:t.stack})}})(),!0):"REMOVE_FROM_QUEUE"===s.type?(r.removeFromQueue(s.itemId).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"SKIP_QUEUE_ITEM"===s.type?(r.skipQueueItem(s.itemId,s.reason).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"CLEAR_QUEUE"===s.type?(r.clearQueue(s.filter).then(()=>{l({success:!0})}).catch(e=>{l({error:e.message})}),!0):"GET_QUEUE_STATUS"===s.type?((async()=>{try{const e=await r.getQueueStatus();l(e)}catch(e){console.error("[Background] Error getting queue status:",e),l({items:[],processing:!1,stats:{queued:0,processing:0,completed:0,failed:0,total:0}})}})(),!0):"CANDIDATE_DETECTED"===s.type?(chrome.storage.local.set({currentCandidate:s.data,candidateDetectedAt:Date.now()}).then(()=>{console.log("[Background] Stored candidate data for side panel"),l({success:!0})}).catch(e=>{console.error("[Background] Failed to store candidate data:",e),l({error:e.message})}),!0):"RECORDER_EVENT"===s.type?(chrome.runtime.sendMessage({type:"RECORDER_EVENT",data:s.data}).catch(()=>{}),l({success:!0}),!0):void 0)),chrome.runtime.onInstalled.addListener(d),d(),console.log(`[Background v${e}] Service worker starting, initializing queue manager...`),r.initialize().then(()=>{console.log(`[Background v${e}] Queue manager initialized successfully`)}).catch(t=>{console.error(`[Background v${e}] Failed to initialize queue manager:`,t)}),chrome.alarms?.onAlarm&&chrome.alarms.onAlarm.addListener(t=>{t.name===s&&r.ensureInitialized().then(()=>r.broadcastQueueStatus()).catch(t=>console.warn(`[Background v${e}] Keep-alive init failed:`,t))})})();
//# sourceMappingURL=background.js.map